﻿//////////////////////////////////////////////
// ProjectLoadResult.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class Material ;
}

/// Includes ---------------------------------

// nkGraphics
#include <NilkinsGraphics/Resources/ResourceSetLoadResult.h>

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>

// nkScripts
#include <NilkinsScripts/Exporter/Project/ProjectLoadResult.h>

/// Internals --------------------------------

namespace nkAstraeus
{
	struct ProjectLoadResultInformation final
	{
		nkMemory::BufferCast<Material*> _materials ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	struct ProjectLoadResult final
	{
		// Results packed
		ProjectLoadResultInformation _astraeusResult ;
		nkGraphics::ResourceSetLoadResult _graphicsResult ;
		nkScripts::ProjectLoadResult _scriptsResult ;
	} ;
}